******************************************
*** This do-file creates the figure 11 ***
******************************************

clear
clear matrix
set mem 500m

use nj_respondents_new.dta, clear

*** define exhaustion point:
* exhaustion date equal to last payment if UI exhausted
gen     exhaustdate = lpdate if weekspaid_all_end >= potdur_extnew

* exhaustion date equal to last payment date if UI ended + remaining weeks
replace exhaustdate = lpdate + 7*max(potdur_extnew - weekspaid_all_end, 0) if weekspaid_all_end < potdur_extnew & lpdate < 18377

* exhaustion date equal to extraction date (end of april 2010) + remaining weeks
replace exhaustdate = 18377  + 7*max(potdur_extnew - weekspaid_all_end, 0) if weekspaid_all_end < potdur_extnew & lpdate >=18377

* exhaustion censored if new claim filed
replace exhaustdate = . if date_new_claim!=.


*** weeks till exhaustion
gen wktoex = round((stopday-exhaustdate)/7)
quietly tab wktoex, gen(wktoex_)
drop wktoex_1

gen varwgt = curwkwgt
tab q2, gen(q2_)
drop q2_1
gen tw_jobsearch_rescaled = 60*tw_jobsearch/7


*** define variable to be used
local varxname = "joboff7d"
local varxtitle = "Job offered in last 7 days"

gen varx = `varxname'

*** sample restriction: drop those with 0 weeks of potential duration or those who have accepted a job
drop if potdur_extnew==0
keep if jobaccepted_pwk==0
keep if jobacceptedint==0
keep wktoex* varx curwkwgt id


*** collapse by weeks till exhaustion
collapse varx (count) N = varx [aw=curwkwgt], by(wktoex)
drop if wktoex < -20
drop if wktoex > 6
drop if N<5
sort wktoex


*** figure 11
graph twoway line varx wktoex if wktoex>=-20 & wktoex<=5, ///
lpattern(solid dash dash) lcolor(black black black) lwidth(medthick thin thin) ///
xlabel(-20(5)5) ///
graphregion(color(white)) ///
title("`varxtitle'") ytitle("") ///
yscale(range(0(0.02)0.14)) ///
ylabel(0(0.02)0.14) ///
note("Universe: no job offer yet accepted.") ///
xline(0) legend(off) xtitle("Weeks until UI exhaustion") 
graph export exhaustion_joboffer.png, replace hei(1200) wid(1650)
graph export exhaustion_joboffer.eps, replace


stop
